
use builtin;
use str;

set edit:completion:arg-completer[broot] = {|@words|
    fn spaces {|n|
        builtin:repeat $n ' ' | str:join ''
    }
    fn cand {|text desc|
        edit:complex-candidate $text &display=$text' '(spaces (- 14 (wcswidth $text)))$desc
    }
    var command = 'broot'
    for word $words[1..-1] {
        if (str:has-prefix $word '-') {
            break
        }
        set command = $command';'$word
    }
    var completions = [
        &'broot'= {
            cand --conf 'Semicolon separated paths to specific config files'
            cand --max-depth 'Only show trees up to a certain depth'
            cand --outcmd 'Where to write the produced cmd (if any)'
            cand --verb-output 'Optional path for verbs using `:write_output`'
            cand -c 'Semicolon separated commands to execute'
            cand --cmd 'Semicolon separated commands to execute'
            cand --color 'Whether to have styles and colors'
            cand --height 'Height (if you don''t want to fill the screen or for file export)'
            cand --set-install-state 'Manually set installation state'
            cand --print-shell-function 'Print to stdout the br function for a given shell'
            cand --listen 'A socket to listen to for commands'
            cand --write-default-conf 'Write default conf files in given directory'
            cand --send 'A socket to send commands to'
            cand --help 'Print help information'
            cand --version 'print the version'
            cand -d 'Show the last modified date of files and directories'
            cand --dates 'Show the last modified date of files and directories'
            cand -D 'Don''t show the last modified date'
            cand --no-dates 'Don''t show the last modified date'
            cand -f 'Only show folders'
            cand --only-folders 'Only show folders'
            cand -F 'Show folders and files alike'
            cand --no-only-folders 'Show folders and files alike'
            cand --show-root-fs 'Show filesystem info on top'
            cand -g 'Show git statuses on files and stats on repo'
            cand --show-git-info 'Show git statuses on files and stats on repo'
            cand -G 'Don''t show git statuses on files and stats on repo'
            cand --no-show-git-info 'Don''t show git statuses on files and stats on repo'
            cand --git-status 'Only show files having an interesting git status, including hidden ones'
            cand -h 'Show hidden files'
            cand --hidden 'Show hidden files'
            cand -H 'Don''t show hidden files'
            cand --no-hidden 'Don''t show hidden files'
            cand -i 'Show git ignored files'
            cand --git-ignored 'Show git ignored files'
            cand -I 'Don''t show git ignored files'
            cand --no-git-ignored 'Don''t show git ignored files'
            cand -p 'Show permissions'
            cand --permissions 'Show permissions'
            cand -P 'Don''t show permissions'
            cand --no-permissions 'Don''t show permissions'
            cand -s 'Show the size of files and directories'
            cand --sizes 'Show the size of files and directories'
            cand -S 'Don''t show sizes'
            cand --no-sizes 'Don''t show sizes'
            cand --sort-by-count 'Sort by count (only show one level of the tree)'
            cand --sort-by-date 'Sort by date (only show one level of the tree)'
            cand --sort-by-size 'Sort by size (only show one level of the tree)'
            cand --sort-by-type 'Same as sort-by-type-dirs-first'
            cand --no-tree 'Do not show the tree, even if allowed by sorting mode'
            cand --tree 'Show the tree, when allowed by sorting mode'
            cand --sort-by-type-dirs-first 'Sort by type, directories first (only show one level of the tree)'
            cand --sort-by-type-dirs-last 'Sort by type, directories last (only show one level of the tree)'
            cand --no-sort 'Don''t sort'
            cand -w 'Sort by size, show ignored and hidden files'
            cand --whale-spotting 'Sort by size, show ignored and hidden files'
            cand -W 'No sort, no show hidden, no show git ignored'
            cand --no-whale-spotting 'No sort, no show hidden, no show git ignored'
            cand -t 'Trim the root too and don''t show a scrollbar'
            cand --trim-root 'Trim the root too and don''t show a scrollbar'
            cand -T 'Don''t trim the root level, show a scrollbar'
            cand --no-trim-root 'Don''t trim the root level, show a scrollbar'
            cand --install 'Install or reinstall the br shell function'
            cand --listen-auto 'create a random socket to listen to for commands'
            cand --get-root 'Ask for the current root of the remote broot'
        }
    ]
    $completions[$command]
}
