_broot() {
    local i cur prev opts cmd
    COMPREPLY=()
    if [[ "${BASH_VERSINFO[0]}" -ge 4 ]]; then
        cur="$2"
    else
        cur="${COMP_WORDS[COMP_CWORD]}"
    fi
    prev="$3"
    cmd=""
    opts=""

    for i in "${COMP_WORDS[@]:0:COMP_CWORD}"
    do
        case "${cmd},${i}" in
            ",$1")
                cmd="broot"
                ;;
            *)
                ;;
        esac
    done

    case "${cmd}" in
        broot)
            opts="-d -D -f -F -g -G -h -H -i -I -p -P -s -S -w -W -t -T -c --help --version --conf --dates --no-dates --only-folders --no-only-folders --show-root-fs --max-depth --show-git-info --no-show-git-info --git-status --hidden --no-hidden --git-ignored --no-git-ignored --permissions --no-permissions --sizes --no-sizes --sort-by-count --sort-by-date --sort-by-size --sort-by-type --no-tree --tree --sort-by-type-dirs-first --sort-by-type-dirs-last --no-sort --whale-spotting --no-whale-spotting --trim-root --no-trim-root --outcmd --verb-output --cmd --color --height --install --set-install-state --print-shell-function --listen --listen-auto --get-root --write-default-conf --send [ROOT]"
            if [[ ${cur} == -* || ${COMP_CWORD} -eq 1 ]] ; then
                COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
                return 0
            fi
            case "${prev}" in
                --conf)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --max-depth)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --outcmd)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --verb-output)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --cmd)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                -c)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --color)
                    COMPREPLY=($(compgen -W "auto yes no" -- "${cur}"))
                    return 0
                    ;;
                --height)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --set-install-state)
                    COMPREPLY=($(compgen -W "undefined refused installed" -- "${cur}"))
                    return 0
                    ;;
                --print-shell-function)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --listen)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --write-default-conf)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --send)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                *)
                    COMPREPLY=()
                    ;;
            esac
            COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
            return 0
            ;;
    esac
}

if [[ "${BASH_VERSINFO[0]}" -eq 4 && "${BASH_VERSINFO[1]}" -ge 4 || "${BASH_VERSINFO[0]}" -gt 4 ]]; then
    complete -F _broot -o nosort -o bashdefault -o default broot
else
    complete -F _broot -o bashdefault -o default broot
fi
