
use builtin;
use str;

set edit:completion:arg-completer[dysk] = {|@words|
    fn spaces {|n|
        builtin:repeat $n ' ' | str:join ''
    }
    fn cand {|text desc|
        edit:complex-candidate $text &display=$text' '(spaces (- 14 (wcswidth $text)))$desc
    }
    var command = 'dysk'
    for word $words[1..-1] {
        if (str:has-prefix $word '-') {
            break
        }
        set command = $command';'$word
    }
    var completions = [
        &'dysk'= {
            cand --color 'whether to have styles and colors'
            cand --remote-stats 'fetch stats of remote volumes'
            cand -c 'columns, eg `-c +inodes` or `-c id+dev+default`'
            cand --cols 'columns, eg `-c +inodes` or `-c id+dev+default`'
            cand -f 'filter, eg `-f ''(size<35G | remote=false) & type=xfs''`'
            cand --filter 'filter, eg `-f ''(size<35G | remote=false) & type=xfs''`'
            cand -s 'sort, eg `inodes`, `type-desc`, or `size-asc`'
            cand --sort 'sort, eg `inodes`, `type-desc`, or `size-asc`'
            cand -u 'units: `SI` (SI norm), `binary` (1024 based), or `bytes` (raw number)'
            cand --units 'units: `SI` (SI norm), `binary` (1024 based), or `bytes` (raw number)'
            cand --csv-separator 'CSV separator'
            cand --strategy 'strategy to use to find information, when several are available'
            cand --timeout 'timeout to use for some operations, eg `10s` or `5ms`'
            cand --help 'print help information'
            cand --version 'print the version'
            cand -a 'show all mount points'
            cand --all 'show all mount points'
            cand --ascii 'use only ASCII characters for table rendering'
            cand --list-cols 'list the column names which can be used in -s, -f, or -c'
            cand -j 'output as JSON'
            cand --json 'output as JSON'
            cand --csv 'output as CSV'
        }
    ]
    $completions[$command]
}
